# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 1
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR1_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:  # Round 1
        return "C"
    
    if len(my_history) == 9:  # Round 10
        return "D"
    
    # Check if opponent's code is simple (always C or always D)
    if "return \"C\"" in opponent_program_code or "return 'C'" in opponent_program_code:
        if len(my_history) % 3 == 2:  # Defect every 3rd round
            return "D"
        else:
            return "C"
    elif "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Check if opponent defected in the last 3 consecutive rounds
    if len(opp_history) >= 3 and all(move == "D" for move in opp_history[-3:]):
        return "D"
    
    # Default Tit-for-Tat
    return opp_history[-1]